option explicit
on error resume next


const CLUSPROP_FORMAT_FILETIME=12


dim bServer2008
bServer2008 = false


sub Print(strPrefix, strText)
	on error resume next
	WScript.Echo strPrefix & " : " & strText
end sub


sub ExpandPrefix(ByRef strPrefix, strExpansion)
	on error resume next
	if ( strPrefix <> "" ) then
		strPrefix = strPrefix & ";"
	end if
	strPrefix = strPrefix & strExpansion
end sub


sub Found(strPrefix, strType, strName)
	on error resume next
	Print strPrefix, "Found " & strType & " """ & strName & """"
end sub


sub ProcessPartition(ByVal strPrefix, oPartition)
	on error resume next
	dim strPartitionName
	strPartitionName = oPartition.DeviceName
	Found strPrefix, "Partition", strPartitionName
	ExpandPrefix strPrefix, "Part=" & strPartitionName
	
	Print strPrefix, "FileSystem=" & oPartition.FileSystem
	Print strPrefix, "FileSystemFlags=" & oPartition.FileSystemFlags
	Print strPrefix, "Flags=" & oPartition.Flags
	Print strPrefix, "MaximumComponentLength=" & oPartition.MaximumComponentLength
	Print strPrefix, "SerialNumber=" & oPartition.SerialNumber
	Print strPrefix, "VolumeLabel=" & oPartition.VolumeLabel
end sub


sub ProcessScsiAddress(ByVal strPrefix, oScsiAddress)
	on error resume next
	ExpandPrefix strPrefix, "ScsiAddr"
	
	Print strPrefix, "Lun=" & oScsiAddress.Lun
	Print strPrefix, "PathId=" & oScsiAddress.PathId
	Print strPrefix, "PortNumber=" & oScsiAddress.PortNumber
	Print strPrefix, "TargetId=" & oScsiAddress.TargetId
end sub


sub ProcessDisk(ByVal strPrefix, oDisk)
	on error resume next
	ExpandPrefix strPrefix, "Disk"
	
	Print strPrefix, "DiskNumber=" & oDisk.DiskNumber
	
	dim oPartition
	for each oPartition in oDisk.Partitions
		ProcessPartition strPrefix, oPartition
	next
	
	ProcessScsiAddress strPrefix, oDisk.ScsiAddress
	
	Print strPrefix, "Signature=" & oDisk.Signature
end sub


sub ProcessResource(ByVal strPrefix, oResource)
	on error resume next
	dim strResourceName
	strResourceName = oResource.Name
	Found strPrefix, "Resource", strResourceName
	ExpandPrefix strPrefix, "Res=" & strResourceName
	
	Print strPrefix, "ClassInfo=" & oResource.ClassInfo
	
	ProcessCommonProperties strPrefix, oResource.CommonProperties
	ProcessCommonROProperties strPrefix, oResource.CommonROProperties
	
	dim strCryptoKey
	for each strCryptoKey in oResource.CryptoKeys
		Print strPrefix, "CryptoKey=" & strCryptoKey
	next
	
	dim oDependency
	for each oDependency in oResource.Dependencies
		Print strPrefix, "Dependency.Name=" & oDependency.Name
	next
	
	dim oDisk
	dim nErrorNum
	set oDisk = nothing
	Err.Clear
	set oDisk = oResource.Disk
	nErrorNum = Err.Number
	
	if (not oDisk is nothing) and (nErrorNum = 0) then
		ProcessDisk strPrefix, oDisk
	else
		Print strPrefix, "Resource is not a storage device (error = " & nErrorNum & ")"
	end if
	
	Print strPrefix, "Group.Name=" & oResource.Group.Name
	Print strPrefix, "OwnerNode.NodeID=" & oResource.OwnerNode.NodeID
	
	dim oPossibleOwnerNode
	for each oPossibleOwnerNode in oResource.PossibleOwnerNodes
		Print strPrefix, "PossibleOwnerNode.NodeID=" & oPossibleOwnerNode.NodeID
	next
	
	ProcessPrivateProperties strPrefix, oResource.PrivateProperties
	ProcessPrivateROProperties strPrefix, oResource.PrivateROProperties
	
	dim strRegistryKey
	for each strRegistryKey in oResource.RegistryKeys
		Print strPrefix, "RegistryKey=" & strRegistryKey
	next
	
	Print strPrefix, "State=" & oResource.State
	Print strPrefix, "TypeName=" & oResource.TypeName
end sub


sub ProcessResourceGroup(ByVal strPrefix, oResourceGroup)
	on error resume next
	dim strResourceGroupName
	strResourceGroupName = oResourceGroup.Name
	Found strPrefix, "Resource group", strResourceGroupName
	ExpandPrefix strPrefix, "ResGrp=" & strResourceGroupName
	
	ProcessCommonProperties strPrefix, oResourceGroup.CommonProperties
	ProcessCommonROProperties strPrefix, oResourceGroup.CommonROProperties
	
	Print strPrefix, "OwnerNode.Name=" & oResourceGroup.OwnerNode.Name
	
	dim oPreferredOwnerNode
	for each oPreferredOwnerNode in oResourceGroup.PreferredOwnerNodes
		Print strPrefix, "PreferredOwnerNode.NodeID=" & oPreferredOwnerNode.NodeID
	next
	
	ProcessPrivateProperties strPrefix, oResourceGroup.PrivateProperties
	ProcessPrivateROProperties strPrefix, oResourceGroup.PrivateROProperties
	
	dim oResource
	for each oResource in oResourceGroup.Resources
		ProcessResource strPrefix, oResource
	next
	
	Print strPrefix, "State=" & oResourceGroup.State	
end sub


function Array2Str(oArr)
	on error resume next
	
	dim strResult
	dim nIndex
	for nIndex = lBound(oArr) to uBound(oArr)
		if strResult <> "" then
			strResult = strResult & ","
		end if
		strResult = strResult & AscB(MidB(oArr, nIndex, 1))
	next
	Array2Str = strResult
end function


sub ProcessValue(ByVal strPrefix, oValue)
	on error resume next
	dim strValueName
	strValueName = oValue.Name
	Found strPrefix, "Value", strValueName
	ExpandPrefix strPrefix, "Val=" & strValueName
	
	dim oDataItem
	for each oDataItem in oValue.Data
		dim nErrorNumber
		Err.Clear
		Print strPrefix, "Data=" & oDataItem
		nErrorNumber = Err.Number
		if nErrorNumber <> 0 then
			if IsArray(oDataItem) then
				Print strPrefix, "Data(array)=" & Array2Str(oDataItem)
			else
				Print strPrefix, "Data(vartype)=" & vartype(oDataItem)
			end if
		end if
	next
	Print strPrefix, "Format=" & oValue.Format
	Print strPrefix, "Length=" & oValue.Length
	Print strPrefix, "Type=" & oValue.Type

	' Due to a bug in Windows Server 2008, we cannot retrieve values formatted as CLUSPROP_FORMAT_FILETIME.
	if bServer2008 and ( oValue.Format = CLUSPROP_FORMAT_FILETIME ) then
		Print strPrefix, "Value=" & "<error>"
	else
		Print strPrefix, "Value=" & oValue.Value
	end if

	Print strPrefix, "ValueCount=" & oValue.ValueCount	
end sub


sub ProcessProperty(ByVal strPrefix, oProperty)
	on error resume next
	dim strPropertyName
	strPropertyName = oProperty.Name
	Found strPrefix, "Property", strPropertyName
	ExpandPrefix strPrefix, "Prop=" & strPropertyName
	
	Print strPrefix, "Format=" & oProperty.Format
	Print strPrefix, "Length=" & oProperty.Length
	Print strPrefix, "Modified=" & oProperty.Modified
	Print strPrefix, "Type=" & oProperty.Type

	' Due to a bug in Windows Server 2008, we cannot retrieve values formatted as CLUSPROP_FORMAT_FILETIME.
	if bServer2008 and ( oProperty.Format = CLUSPROP_FORMAT_FILETIME ) then
		Print strPrefix, "Value=" & "<error>"
	else
		Print strPrefix, "Value=" & oProperty.Value
	end if

	Print strPrefix, "ValueCount=" & oProperty.ValueCount

	dim oValue
	for each oValue in oProperty.Values
		ProcessValue strPrefix, oValue
	next
end sub


sub ProcessCommonProperties(ByVal strPrefix, oCommonProperties)
	on error resume next
	ExpandPrefix strPrefix, "CommonProps"
	
	dim oProperty
	for each oProperty in oCommonProperties
		ProcessProperty strPrefix, oProperty
	next
end sub


sub ProcessCommonROProperties(ByVal strPrefix, oCommonROProperties)
	on error resume next
	ExpandPrefix strPrefix, "CommonROProps"
	
	dim oProperty
	for each oProperty in oCommonROProperties
		ProcessProperty strPrefix, oProperty
	next
end sub


sub ProcessPrivateProperties(ByVal strPrefix, oPrivateProperties)
	on error resume next
	ExpandPrefix strPrefix, "PrivateProps"
	
	dim oProperty
	for each oProperty in oPrivateProperties
		ProcessProperty strPrefix, oProperty
	next
end sub


sub ProcessPrivateROProperties(ByVal strPrefix, oPrivateROProperties)
	on error resume next
	ExpandPrefix strPrefix, "PrivateROProps"
	
	dim oProperty
	for each oProperty in oPrivateROProperties
		ProcessProperty strPrefix, oProperty
	next
end sub


sub ProcessResourceType(ByVal strPrefix, oResourceType)
	on error resume next
	dim strResourceTypeName
	strResourceTypeName = oResourceType.Name
	Found strPrefix, "ResourceType", strResourceTypeName
	ExpandPrefix strPrefix, "ResType=" & strResourceTypeName
	
	' Err indicates that AvailableDisks is not a collection.
	dim oAvailableDisk
	for each oAvailableDisk in oResourceType.AvailableDisks
		Print strPrefix, "AvailableDisk.DiskNumber=" & oAvailableDisk.DiskNumber
	next
	
	ProcessCommonProperties strPrefix, oResourceType.CommonProperties
	ProcessCommonROProperties strPrefix, oResourceType.CommonROProperties
	
	dim oPossibleOwnerNode
	for each oPossibleOwnerNode in oResourceType.PossibleOwnerNodes
		Print strPrefix, "PossibleOwnerNode.NodeID=" & oPossibleOwnerNode.NodeID
	next
	
	ProcessPrivateProperties strPrefix, oResourceType.PrivateProperties
	ProcessPrivateROProperties strPrefix, oResourceType.PrivateROProperties
end sub


sub ProcessVersion(ByVal strPrefix, oVersion)
	on error resume next
	ExpandPrefix strPrefix, "Ver"
	
	Print strPrefix, "BuildNumber=" & oVersion.BuildNumber
	Print strPrefix, "ClusterHighestVersion=" & oVersion.ClusterHighestVersion
	Print strPrefix, "ClusterLowestVersion=" & oVersion.ClusterLowestVersion
	Print strPrefix, "CSDVersion=" & oVersion.CSDVersion
	Print strPrefix, "Flags=" & oVersion.Flags
	Print strPrefix, "MajorVersion=" & oVersion.MajorVersion
	Print strPrefix, "MinorVersion=" & oVersion.MinorVersion
	Print strPrefix, "MixedVersion=" & oVersion.MixedVersion
	Print strPrefix, "Name=" & oVersion.Name
	Print strPrefix, "VendorId=" & oVersion.VendorId
end sub


sub ProcessNetInterface(ByVal strPrefix, oNetInterface)
	on error resume next
	dim strNetInterfaceName
	strNetInterfaceName = oNetInterface.Name
	Found strPrefix, "NetInterface", strNetInterfaceName
	ExpandPrefix strPrefix, "NetIFace=" & strNetInterfaceName
	
	ProcessCommonProperties strPrefix, oNetInterface.CommonProperties
	ProcessCommonROProperties strPrefix, oNetInterface.CommonROProperties
		
	ProcessPrivateProperties strPrefix, oNetInterface.PrivateProperties
	ProcessPrivateROProperties strPrefix, oNetInterface.PrivateROProperties
	
	Print strPrefix, "State=" & oNetInterface.State
end sub


sub ProcessNetwork(ByVal strPrefix, oNetwork)
	on error resume next
	dim strNetworkName
	strNetworkName = oNetwork.Name
	Found strPrefix, "Network", strNetworkName
	ExpandPrefix strPrefix, "Net=" & strNetworkName
	
	ProcessCommonProperties strPrefix, oNetwork.CommonProperties
	ProcessCommonROProperties strPrefix, oNetwork.CommonROProperties
	
	dim oNetInterface
	for each oNetInterface in oNetwork.NetInterfaces
		Print strPrefix, "NetInterface.Name=" & oNetInterface.Name
	next
	
	Print strPrefix, "NetworkID=" & oNetwork.NetworkID
		
	ProcessPrivateProperties strPrefix, oNetwork.PrivateProperties
	ProcessPrivateROProperties strPrefix, oNetwork.PrivateROProperties
	
	Print strPrefix, "State=" & oNetwork.State
end sub


sub ProcessNode(ByVal strPrefix, oNode)
	on error resume next
	dim strNodeId
	strNodeId = oNode.NodeID
	Found strPrefix, "Node", strNodeID
	ExpandPrefix strPrefix, "Node=" & strNodeID
	
	ProcessCommonProperties strPrefix, oNode.CommonProperties
	ProcessCommonROProperties strPrefix, oNode.CommonROProperties
	
	dim oNetInterface
	for each oNetInterface in oNode.NetInterfaces
		Print strPrefix, "NetInterface.Name=" & oNetInterface.Name
	next
	
	ProcessPrivateProperties strPrefix, oNode.PrivateProperties
	ProcessPrivateROProperties strPrefix, oNode.PrivateROProperties
	
	dim oResourceGroup
	for each oResourceGroup in oNode.ResourceGroups
		Print strPrefix, "ResourceGroup.Name=" & oResourceGroup.Name
	next
	
	Print strPrefix, "State=" & oNode.State
end sub


sub ProcessCluster(ByVal strPrefix, oCluster)
	on error resume next
	dim strClusterName
	strClusterName = oCluster.Name
	Found strPrefix, "Cluster", strClusterName
	ExpandPrefix strPrefix, "Clust=" & strClusterName
	
	ProcessCommonProperties strPrefix, oCluster.CommonProperties
	ProcessCommonROProperties strPrefix, oCluster.CommonROProperties
	
	dim oNetInterface
	for each oNetInterface in oCluster.NetInterfaces
		ProcessNetInterface strPrefix, oNetInterface
	next
	
	dim oNetwork
	for each oNetwork in oCluster.Networks
		ProcessNetwork strPrefix, oNetwork
	next
	
	dim oNode
	for each oNode in oCluster.Nodes
		ProcessNode strPrefix, oNode
	next
	
	ProcessPrivateProperties strPrefix, oCluster.PrivateProperties
	ProcessPrivateROProperties strPrefix, oCluster.PrivateROProperties
	
	Print strPrefix, "QuorumLogSize=" & oCluster.QuorumLogSize
	Print strPrefix, "QuorumPath=" & oCluster.QuorumPath
	Print strPrefix, "QuorumResource.Name=" & oCluster.QuorumResource.Name
	
	dim oResourceGroup
	for each oResourceGroup in oCluster.ResourceGroups
		ProcessResourceGroup strPrefix, oResourceGroup
	next
	
	dim oResourceType
	for each oResourceType in oCluster.ResourceTypes
		ProcessResourceType strPrefix, oResourceType
	next
	
	ProcessVersion strPrefix, oCluster.Version
end sub


WScript.Echo "Creating cluster management object"
dim oCluster
set oCluster = CreateObject("MSCluster.Cluster")

WScript.Echo "Opening local cluster"
oCluster.open("")

dim oNetwork
Set oNetwork = WScript.CreateObject("WScript.Network")
dim strComputerName
strComputerName = oNetwork.ComputerName
WScript.Echo "Local computer : " & strComputerName

dim oNode
set oNode = oCluster.Nodes(strComputerName)

dim oMajorVersion
set oMajorVersion = oNode.CommonROProperties("MajorVersion")

WScript.Echo "Major version : " & oMajorVersion

bServer2008 = oMajorVersion.Value = 6

dim strPrefix
ProcessCluster "", oCluster
