Option Explicit

function ComputerCommonName
    dim oADSI
    Set oADSI = CreateObject("ADSystemInfo")
    ComputerCommonName = oADSI.ComputerName
end function

function DnsDomainName
    dim oADSI
    set oADSI = CreateObject("ADSystemInfo")
    DnsDomainName = oADSI.DomainDNSName
end function

function DomainMode
    dim oADSI
    set oADSI = CreateObject("ADSystemInfo")

    if oADSI.IsNativeMode then
        DomainMode = "Native"
    else
        DomainMode = "Mixed"
    end if
end function

function LevelString(iLevel)
    dim strResult

    select case iLevel
    case 0
        strResult = "Windows 2000"
    case 1
        strResult = "Windows 2003 Interim"
    case 2
        strResult = "Windows Server 2003"
    case 3
        strResult = "Windows Server 2008"
    case 4
        strResult = "Windows Server 2008 R2 / Windows 7"
    case else
        strResult = "Unknown"
    end select

    strResult = strResult & " (" & iLevel & ")"

    LevelString = strResult
end function

function DomainFunctionalLevel(strDnsDomainName)
    dim objDomain
    set objDomain = GetObject("LDAP://" & strDnsDomainName)

    dim iLevel
    iLevel = objDomain.Get("msDS-Behavior-Version")

    DomainFunctionalLevel = LevelString(iLevel)
end function

function ForestFunctionalLevel
    dim objRootDSE
    set objRootDSE = GetObject("LDAP://RootDSE")

    dim objConfiguration
    set objConfiguration = GetObject("LDAP://cn=partitions," & objRootDSE.Get("configurationNamingContext") )

    dim iLevel
    iLevel = objConfiguration.Get("msDS-Behavior-Version")

    ForestFunctionalLevel = LevelString(iLevel)
end function

function IsDomainController(strComputerCommonName, strDnsDomainName)
    dim objAccount
    set objAccount = GetObject("LDAP://" & strDnsDomainName & "/" & strComputerCommonName)

    dim iLevel
    iLevel = objAccount.Get("userAccountControl")

    IsDomainController = (iLevel And 8192) <> 0
end function

on error resume next

dim strDnsDomainName
strDnsDomainName = DnsDomainName

dim strComputerCommonName
strComputerCommonName = ComputerCommonName

WScript.Echo "DNS domain=" & strDnsDomainName
WScript.Echo "Computer common name=" & strComputerCommonName
WScript.Echo "Domain mode=" & DomainMode
WScript.Echo "Domain functional level=" & DomainFunctionalLevel(strDnsDomainName)
WScript.Echo "Forest functional level=" & ForestFunctionalLevel
WScript.Echo "Is domain controller=" & IsDomainController(strComputerCommonName, strDnsDomainName)
