Option Explicit

function DnsDomainName
	dim oADSI
	set oADSI = CreateObject("ADSystemInfo")
	DnsDomainName = oADSI.DomainDNSName
end function

sub AppendStringList(byref strStringList, byval strStringItem)
	if len(strStringList) = 0 then
		strStringList = strStringItem
	else
		strStringList = strStringList & "," & strStringItem
	end if
end sub

sub PrintInfoForDomainGroup(strDnsDomainName, strGroupName)
	WScript.Echo "Domain group: " & strGroupName

	dim oConnection
	set oConnection = CreateObject("ADODB.Connection")

	oConnection.Provider = "ADsDSOObject"
	oConnection.Open

	dim oCommand
	set oCommand = CreateObject("ADODB.Command")
	set oCommand.ActiveConnection = oConnection
	oCommand.CommandText = "<LDAP://" & strDnsDomainName & ">;(&(objectclass=group)(objectcategory=group)(name=" & strGroupName & "));ADsPath;Subtree"
	oCommand.Properties("Page Size") = 1000

	dim oRecordSet
	set oRecordSet = oCommand.Execute()

	while not oRecordSet.EOF
		dim oGroup
		set oGroup = GetObject(oRecordSet.Fields.Item("ADsPath").Value)

		dim iGroupType
		iGroupType = oGroup.Get("groupType")

		dim strGroupType
		if iGroupType And 1 then
			AppendStringList strGroupType, "System"
		end if
		if iGroupType And 2 then
			AppendStringList strGroupType, "Global"
		end if
		if iGroupType And 4 then
			AppendStringList strGroupType, "Domain local"
		end if
		if iGroupType And 8 then
			AppendStringList strGroupType, "Universal"
		end if
		if iGroupType And 16 then
			AppendStringList strGroupType, "APP_BASIC"
		end if
		if iGroupType And 32 then
			AppendStringList strGroupType, "APP_QUERY"
		end if
		if iGroupType And -2147483648 then
			AppendStringList strGroupType, "Security enabled"
		end if

		strGroupType = strGroupType + " (" & iGroupType & ")"
		WScript.Echo "groupType=" & strGroupType

		oRecordSet.MoveNext
	wend

	WScript.Echo
end sub

sub PrintInfoForLocalGroup(strDnsDomainName, strGroupName)
	WScript.Echo "Local group: " & strGroupName

	dim oWMI
	set oWMI = GetObject("winmgmts:\\.\root\cimv2")

	dim oItems
	set oItems = oWMI.ExecQuery ("Select * from Win32_Group Where LocalAccount = True And Name = '" & strGroupName & "'")

    dim oItem
	for each oItem in oItems
		WScript.Echo "SID=" & oItem.SID
		WScript.Echo "SID type=" & oItem.SIDType
		WScript.Echo "Status=" & oItem.Status
	next

	WScript.Echo
end sub

on error resume next

dim strDnsDomainName
strDnsDomainName = DnsDomainName

PrintInfoForDomainGroup strDnsDomainName, "PMX_ADMIN"
PrintInfoForDomainGroup strDnsDomainName, "Sophos PureMessage Administrators"
PrintInfoForDomainGroup strDnsDomainName, "Distributed COM Users"

PrintInfoForLocalGroup strDnsDomainName, "PMX_ADMIN"
PrintInfoForLocalGroup strDnsDomainName, "Sophos PureMessage Administrators"
PrintInfoForLocalGroup strDnsDomainName, "Distributed COM Users"
