Dim g_DestinationServerName
Dim g_ConfigFolderPath
Dim g_Verbose

'PMW internal constants
Const SAVEX_SMTP_CONFIG = 1
Const SAVEX_STORE_CONFIG = 2
Const SAVEX_GENERAL_CONFIG = 4
Const SAVEX_LOCAL_CONFIG = 8


' Read command line arguments
ReadArguments()


'Load configuration from disk
Dim oFSO
Set oFSO = CreateObject("Scripting.FilesystemObject")

Dim oCfgFolder
Set oCfgFolder = oFSO.GetFolder(g_ConfigFolderPath)

Log "Configuration folder got successfully!"


' Load general config
Dim fileGC
Set fileGC = oFSO.GetFile(oCfgFolder.Path & "\GeneralConfig.xml")
Dim g_oConfigGeneralData
Set g_oConfigGeneralData = CreateObject("autoconfig.generalconfig")
g_oConfigGeneralData.XML = fileGC.OpenAsTextStream(1).ReadAll

' Load SMTP config
Dim fileSMTP
Set fileSMTP = oFSO.GetFile(oCfgFolder.Path & "\SMTPConfig.xml")
Dim g_oConfigSMTPData
Set g_oConfigSMTPData = CreateObject("autoconfig.smtpconfig")
g_oConfigSMTPData.XML = fileSMTP.OpenAsTextStream(1).ReadAll

' Load store config
Dim fileStore
Set fileStore = oFSO.GetFile(oCfgFolder.Path & "\StoreConfig.xml")
Dim g_oConfigStoreData
Set g_oConfigStoreData = CreateObject("autoconfig.ExchangeStoreConfig")
g_oConfigStoreData.XML = fileStore.OpenAsTextStream(1).ReadAll

Log "Configuration loaded from disk successfully!"


'Save configuration
Dim oSavexMgr
Set oSavexMgr = CreateObject("SavexSrvc.SavexMgr", g_DestinationServerName)

Dim g_oConfigMgr
Set g_oConfigMgr = oSavexMgr.GetConfigManager

'Get destination server's current configuration
Dim oCurrentCnfg
Set oCurrentCnfg = g_oConfigMgr.RetrieveConfig(SAVEX_GENERAL_CONFIG + SAVEX_SMTP_CONFIG + SAVEX_STORE_CONFIG, False, True, False)

'Assign the changed configuration but don't change the master server name
g_oConfigGeneralData.MasterServer = oCurrentCnfg.GeneralConfigObj.MasterServer
oCurrentCnfg.GeneralConfig = g_oConfigGeneralData.XML
oCurrentCnfg.SMTPConfig = g_oConfigSMTPData.XML
oCurrentCnfg.StoreConfig = g_oConfigStoreData.XML

g_oConfigMgr.SaveConfig SAVEX_GENERAL_CONFIG + SAVEX_SMTP_CONFIG + SAVEX_STORE_CONFIG, True, oCurrentCnfg

Log "Configuration saved to database successfully!"


'Notify servers in the group about the configuration change
Dim oGroupManager
Set oGroupManager = g_oConfigMgr.GetGroupManager

Dim oCurrentGroup
Set oCurrentGroup = oGroupManager.GetCurrentGroup(g_DestinationServerName)

Dim ServersList
ServersList = oCurrentGroup.GetServers

Dim Server
For Each Server In ServersList
	NotifyConfigChangeToServer Server.Name, SAVEX_GENERAL_CONFIG + SAVEX_SMTP_CONFIG + SAVEX_STORE_CONFIG
Next

Log "Configuration imported successfully!"
WScript.Quit(0)


'''''''''''' Helper routines '''''''''''''''''''


Sub ReadArguments()

    g_Verbose = True
    
    If WScript.Arguments.Count = 0 Then
        DisplayUsage()
        WScript.Quit(0)
    End If

    Dim arg : For Each arg in WScript.Arguments
        If  LCase(arg) = "usage" or _
            LCase(arg) = "help" or _
            Left(arg, 1) = "?" or _
            arg = "/?" or _
            arg = "-?" Then
            DisplayUsage()
            WScript.Quit(0)
        End If

        Dim eqPos : eqPos = InStr(arg, "=")
        If (eqPos > 0) Then
            Dim name : name =  LCase(Left(arg, eqPos - 1))
            Dim value : value = LCase(Mid(arg, eqPos + 1))

            Select Case name
                Case "destserver"
                    g_DestinationServerName = CStr(value)
                    
                Case "configfolder"
                    g_ConfigFolderPath = CStr(value)

                Case "verbose"
                    g_Verbose = CBool(value)

                Case Else
                    DisplayUsage()
                    WScript.Quit(1)
            End Select
        End If
    Next

End Sub


Sub DisplayUsage
    WScript.Echo ""
    WScript.Echo "Imports PureMessage configuration files stored on disk to a specified server"
    WScript.Echo ""
    WScript.Echo "NOTE: If multiple servers exist in a PureMessage group then importing to one server will result in the configuration being applied to all servers in the group."
    WScript.Echo ""
    WScript.Echo "Usage:"
    WScript.Echo "    cscript " & WScript.ScriptName & " {<prop>=<value>, ...}"
    WScript.Echo "    cscript " & WScript.ScriptName & " usage|help|?|-?|/?"
    WScript.Echo ""
    WScript.Echo "Properties:"
    WScript.Echo "   DestServer   = <Name of detination server to which configuration should be imported> *Mandatory*"
    WScript.Echo "   ConfigFolder = <Path to folder on disk where configuration files are located> *Mandatory*"
    WScript.Echo "   Verbose      = True | False  Default: True"
    WScript.Echo ""
    WScript.Echo "Example:"
    WScript.Echo "    cscript " & WScript.ScriptName & " DestServer=PMSERVER ConfigFolder=""c:\PM Config"""
End Sub


Sub NotifyConfigChangeToServer(ServerName, ConfigType)
	Dim oSavexMgr
	Set oSavexMgr = CreateObject("SavexSrvc.SavexMgr", ServerName)
	oSavexMgr.UpdateConfig ConfigType
	Log "Configuration change notified to [" & ServerName & "] successfully!"
End Sub

Sub Log(strLog)
    If g_Verbose Then
        WScript.Echo strLog
    End If
End Sub
