<SCRIPT LANGUAGE="VBSCRIPT">

Option Explicit

' Edit this file-path, to specify where messages and a log file will be written.
Const g_OutputDirectory = "c:\smtpdumper\out"

Const cdoContentMediaType = "urn:schemas:httpmail:content-media-type"
Const cdoRecipientList = "http://schemas.microsoft.com/cdo/smtpenvelope/recipientlist"
Const cdoMessageId = "urn:schemas:mailheader:message-id"
Const cdoMessageStatus = "http://schemas.microsoft.com/cdo/smtpenvelope/messagestatus"
Const cdoStatAbortDelivery = 2
Const cdoRunNextSink = 0
Const cdoSkipRemainingSinks = 1
Const cForAppending = 8
Const adErrUnavailable = &he98

Dim g_logFile
Dim b_logFileExists : b_logFileExists = False

Dim g_fso : Set g_fso = CreateObject("Scripting.FileSystemObject")

Dim g_sDate : g_sDate = DateTimeNow()

Sub ISMTPOnArrival_OnArrival(ByVal oMsg, EventStatus)
    On Error Resume Next

    EventStatus = cdoRunNextSink

    Dim flds : Set flds = oMsg.Fields

    LogLine String(5, ">") & g_sDate & String(60, ">")
    LogLine "Message ID: " & flds(cdoMessageId).Value
    LogLine "Subject: " & oMsg.Subject

    Err.Clear
    Dim recipList : recipList = oMsg.EnvelopeFields(cdoRecipientList).Value
    Dim errNum : errNum = Err.number
    If errNum = adErrUnavailable Then
        Err.Clear
    ElseIf errNum = 0 Then
        LogLine "Envelope recipients: " & recipList
    End If
    HandleErr

    Dim dumpPath : dumpPath = DumpStream(oMsg.GetStream)
    If Len(dumpPath) > 0 Then
        LogLine "Dump path: " & dumpPath
    End If
    HandleErr

    ' If req'd, drop the message.
'    If 1 = InStr(LCase(oMsg.Subject), "puremessage") Then
    If False Then
        oMsg.EnvelopeFields(cdoMessageStatus) = cdoStatAbortDelivery
        HandleErr
        oMsg.EnvelopeFields.Update
        HandleErr
        EventStatus = cdoSkipRemainingSinks
        LogLine "*** Deleted Message ***"
    End If

    ' If req'd, log the msg structure.
    If False Then
        PrintMessageStructure(oMsg)
    End If

    LogLine String(80, "<")
    LogLine ""

End Sub

Sub PrintMessageStructure(ByRef oMsg)
    PrintBodyPartStructure oMsg.BodyPart, ""
End Sub

Sub PrintBodyPartStructure(ByRef oBP, indent)
    LogLine(indent & "BodyPart" & String(30, "="))
    LogLine(indent & "ContentMediaType: ...... " & oBP.ContentMediaType)
    LogLine(indent & "ContentTransferEncoding: " & oBP.ContentMediaType)

    Dim oBPKid : For Each oBPKid In oBP.BodyParts
        PrintBodyPartStructure oBP, "-" + indent
    Next

    LogLine(indent & String(38, "="))
End Sub

Function DumpStream(ByRef oStm)
    On Error Resume Next

    Const adSaveCreateOverWrite = 2

    Dim stmName : stmName = GetTempFilePath(g_OutputDirectory)

    oStm.SaveToFile stmName, adSaveCreateOverWrite
    If HandleErr() = 0 Then
        DumpStream = stmName
    Else
        LogLine "Failed dumping to " & stmName
        DumpStream = ""
    End If
End Function

Sub Log(Text)
    On Error Resume Next
    If Not b_logFileExists Then
        g_fso.CreateFolder g_OutputDirectory
        Set g_logFile = g_fso.OpenTextFile(g_OutputDirectory & "\OnArrival.log", cForAppending, True)
        b_logFileExists = True
    End If

    If Not g_logFile Is Nothing Then
        g_logFile.Write(Text)
    End If
End Sub

Sub LogLine(Text)
    Log(Text & VbCrLf)
End Sub

Function HandleErr
    Dim errNum : errNum = Err.number
    If 0 <> errNum Then
        LogLine "Error: 0x" & Hex(errNum) & " :: " & Err.Description
        Err.Clear
    End If

    HandleErr = errNum
End Function

Function PrePad(number, width)
   PrePad = Right(String(width, "0") & CStr(number), width)
End Function

' Output: Date + time, formatted as yyyymmdd-hhmmss (15 chars wide)
Function DateTimeNow()
    Dim d : d = Date()
    Dim t : t = Time()

    DateTimeNow =   PrePad(Year(d), 4) _
                  & PrePad(Month(d), 2) _
                  & PrePad(Day(d), 2) _
                  & "-" _
                  & PrePad(Hour(t), 2) _
                  & PrePad(Minute(t), 2) _
                  & PrePad(Second(t), 2)
End Function

' Output a temporary name, based on the date+time.
Function GetTempFilePath(sDir)
    Dim ctr : For ctr = 1 To 9999
        GetTempFilePath = sDir & "\" & g_sDate & "-" & PrePad(ctr, 4) & ".tmp"
        If Not g_fso.FileExists(GetTempFilePath) Then Exit For
    Next
End Function

</SCRIPT>